<?php

declare(strict_types=1);

namespace SimpleSAML\XML\Exception;

use LibXMLError;

use function sprintf;

/**
 */
final class UnparseableXMLException extends RuntimeException
{
    /** @var string[] */
    private const LEVELMAP = [
        LIBXML_ERR_WARNING => 'WARNING',
        LIBXML_ERR_ERROR   => 'ERROR',
        LIBXML_ERR_FATAL   => 'FATAL',
    ];


    /**
     * Constructor for UnparseableXMLException
     *
     * @param \LibXMLError $error
     */
    public function __construct(LibXMLError $error)
    {
        $message = sprintf(
            'Unable to parse XML - "%s[%d]": "%s" in "%s" at line %d on column %d"',
            self::LEVELMAP[$error->level],
            $error->code,
            $error->message,
            $error->file ?: '(string)',
            $error->line,
            $error->column,
        );

        parent::__construct($message);
    }
}
